unit userscript;

function lowerShieldValue(e: IInterface; k: String): integer;
var
  nc, v, nv: Integer;
  val, k1: String;
begin
  Result := 0;
  nc := 60; // reduce Shield strength by 40%
  k1 := k+'[1]';
  AddMessage('Lowering Shield strength by 40% on '+GetElementEditValues(e, 'EDID'));
  val := GetEditValue(ElementByPath(e, k1));
  v := int(val);
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, k1), Format(nv, [GetEditValue(ElementByPath(e, k1)), IntToHex(FormID(e),8)]));
end;

function findShieldsToLower(e: IInterface; k: String): integer;
var
  k1, t1, t2: String;
begin
  Result := 0;
  k1 := k+'[0]';
  if ElementByPath(e, k1) <> nil then
  begin
	t1 := 'ShieldMaxHealth "Shield Max Health" [AVIF:0005BFA8]';
	t2 := 'ShieldHealth "Shield Health" [AVIF:0024A05F]';
	k1 := GetEditValue(ElementByPath(e, k1));
    if (k1 = t1) or (k1 = t2) then lowerShieldValue(e, k);
  end;
end;

function adjustShields(e: IInterface): integer;
var
  I: Integer;
  t1, t2, etyp: String;
begin
  Result := 0;
  t1 := 'gbf_DarkStar_MS';
  t2 := 'gbf_DarkStar_XS';
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),Length(t1));
  if (etyp = t1) or (etyp = t2) then
	begin
	  for I := 1 to 20 do findShieldsToLower(e, '[4]\[1]\[1]\[0]\['+IntToStr(I)+']\');
	end;
end;

function lowerReactorPowerIfPresent(e: IInterface; k: String): integer;
var
  nc, v, nv: Integer;
  val, k1, k2, t: String;
begin
  Result := 0;
  t := 'SpaceshipMaxAvailablePower "Power Generated" [AVIF:00001018]';
  nc := 90; // reduce Reactor Power by 10%
  k1 := k+'[0]';
  k2 := k+'[1]';
  if ElementByPath(e, k1) <> nil then
  begin
    if GetEditValue(ElementByPath(e, k1)) = t then
    begin
	  AddMessage('Reducing Reactor Power by 10% on '+GetElementEditValues(e, 'EDID'));
	  val := GetEditValue(ElementByPath(e, k2));
	  v := int(val);
	  nv := v * (nc / 100);
	  SetEditValue(ElementByPath(e, k2), Format(nv, [GetEditValue(ElementByPath(e, k2)), IntToHex(FormID(e),8)]));
    end;
  end;
end;

function adjustReactors(e: IInterface): integer;
var
  I: Integer;
  t1, t2, etyp: String;
begin
  Result := 0;
  t1 := 'gbf_DarkStar_MR';
  t2 := 'gbf_DarkStar_XR';
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),Length(t1));
  if (etyp = t1) or (etyp = t2) then
	begin
	  for I := 1 to 15 do lowerReactorPowerIfPresent(e, '[4]\[1]\[1]\[0]\['+IntToStr(I)+']\');
	end;
end;

function lowerEngineSpeedIfPresent(e: IInterface; k: String): integer;
var
  v, nv, nc: Integer;
  val, k1, k2, t: String;
begin
  Result := 0;
  t := 'SpaceshipEnginePartMaxForwardSpeed "Max Speed" [AVIF:00278988]';
  nc := 5; // reduce Engine Speed by 5
  k1 := k+'[0]';
  k2 := k+'[1]';
  if ElementByPath(e, k1) <> nil then
  begin
    if GetEditValue(ElementByPath(e, k1)) = t then
    begin
	  AddMessage('Changing Engine Speed on '+GetElementEditValues(e, 'EDID'));
	  val := GetEditValue(ElementByPath(e, k2));
	  v := int(val);
	  nv := v - nc;
	  SetEditValue(ElementByPath(e, k2), Format(nv, [GetEditValue(ElementByPath(e, k2)), IntToHex(FormID(e),8)]));
    end;
  end;
end;

function adjustEngines(e: IInterface): integer;
var
  I: Integer;
  t1, t2, etyp: String;
begin
  Result := 0;
  t1 := 'gbf_DarkStar_ME';
  t2 := 'gbf_DarkStar_XE';
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),Length(t1));
  if (etyp = t1) or (etyp = t2) then
  begin
    for I := 1 to 30 do lowerEngineSpeedIfPresent(e, '[4]\[1]\[1]\[0]\['+IntToStr(I)+']\');
  end;
end;

function lowerGravJumpIfPresent(e: IInterface; k: String): integer;
var
  nc, v, nv: Integer;
  val, k1, k2, t: String;
begin
  Result := 0;
  t := 'SpaceshipGravJumpThrust "Grav Jump Thrust" [AVIF:002BFAFD]';
  nc := 90; // reduce Jump Thrust by 10%
  k1 := k+'[0]';
  k2 := k+'[1]';
  if ElementByPath(e, k1) <> nil then
  begin
    if GetEditValue(ElementByPath(e, k1)) = t then
    begin
	  AddMessage('Reducing Jump Thrust by 10% on '+GetElementEditValues(e, 'EDID'));
	  val := GetEditValue(ElementByPath(e, k2));
	  v := int(val);
	  nv := v * (nc / 100);
	  SetEditValue(ElementByPath(e, k2), Format(nv, [GetEditValue(ElementByPath(e, k2)), IntToHex(FormID(e),8)]));
    end;
  end;
end;

function adjustGravDrives(e: IInterface): integer;
var
  I: Integer;
  t1, t2, etyp: String;
begin
  Result := 0;
  t1 := 'gbf_DarkStar_MD';
  t2 := 'gbf_DarkStar_XD';
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),Length(t1));
  if (etyp = t1) or (etyp = t2) then
  begin
    for I := 1 to 30 do lowerGravJumpIfPresent(e, '[4]\[1]\[1]\[0]\['+IntToStr(I)+']\');
  end;
end;

function nerfWeaponDamage(e: IInterface): integer;
var
  nc, v, nv: Integer;
  val: String;
begin
  Result := 0;
  nc := 90; // reduce all types of ship weapon damage by 10%
  AddMessage('Adjusting all damage types by -10% on '+GetElementEditValues(e, 'EDID'));
  
  // Adjust ATTACK damage
  val := GetEditValue(ElementByPath(e, '[17]\[0]'));
  val := StringReplace(val, '.000000', '', [rfReplaceAll, rfIgnoreCase]);
  v := int(val);
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, '[17]\[0]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));

  // Adjust SHIELD damage
  val := GetEditValue(ElementByPath(e, '[18]\[0]\[1]'));
  v := int(val);
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, '[18]\[0]\[1]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));

  // Adjust EM damage
  val := GetEditValue(ElementByPath(e, '[18]\[1]\[1]'));
  v := int(val);
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, '[18]\[1]\[1]'), Format(nv, [GetEditValue(ElementByPath(e, '[17]\[0]')), IntToHex(FormID(e),8)]));
end;

function adjustWeapons(e: IInterface): integer;
var
  etyp: String;
begin
  Result := 0;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),3);
  if etyp = 'sw_' then nerfWeaponDamage(e);
end;

function reducePriceByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  v := GetElementEditValues(e, 'DATA');
  nv := v * (nc / 100);
  SetElementEditValues(e, 'DATA', Format(nv, [GetElementEditValues(e, 'DATA'), IntToHex(FormID(e),8)]));
end;

function reduceArmorValueByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
  p: String;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  p := '[16]\[0]';
  v := GetEditValue(ElementByPath(e, p));
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, p), Format(nv, [GetEditValue(ElementByPath(e, p)), IntToHex(FormID(e),8)]));
end;

function reduceWeaponValueByHalf(e: IInterface): integer;
var
  v, nv, nc: Integer;
  p: String;
begin
  Result := 0;
  AddMessage('Reducing PRICE by 50% on '+GetElementEditValues(e, 'EDID'));
  nc := 50;
  p := '[29]\[2]';
  v := GetEditValue(ElementByPath(e, p));
  nv := v * (nc / 100);
  SetEditValue(ElementByPath(e, p), Format(nv, [GetEditValue(ElementByPath(e, p)), IntToHex(FormID(e),8)]));
end;

function removePerks(e: IInterface): integer;
begin
  Result := 0;
  AddMessage('Removing Perks on '+GetElementEditValues(e, 'EDID')+'. Be sure to add Piloting back to Reactors after.');
  RemoveElement(e, 'RQPK');
end;

function applyNoPerksCheaper(e: IInterface): integer;
var
  etyp: String;
begin
  Result := 0;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),3);
  if etyp = 'co_' then
  begin
    removePerks(e);
    reducePriceByHalf(e);
  end;
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),16);
  if etyp = 'DarkStar_Armor_U' then reduceArmorValueByHalf(e);
  etyp := LeftStr(GetElementEditValues(e, 'EDID'),24);
  if etyp = 'DarkStar_Starborn_Weapon' then reduceWeaponValueByHalf(e);
end;

function Process(e: IInterface): integer;
begin
	Result := 0;
	adjustEngines(e);
	adjustGravDrives(e);
	adjustReactors(e);
	adjustShields(e);
	adjustWeapons(e);
	applyNoPerksCheaper(e);
end;

end.